/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.entities.components;

import com.badlogic.gdx.ai.msg.MessageDispatcher;
import com.badlogic.gdx.math.Vector2;
import technology.rocketjump.undermount.assets.entities.furniture.model.DoorState;
import technology.rocketjump.undermount.entities.model.Entity;
import technology.rocketjump.undermount.entities.model.EntityType;
import technology.rocketjump.undermount.entities.model.physical.LocationComponent;
import technology.rocketjump.undermount.mapping.model.TiledMap;
import technology.rocketjump.undermount.mapping.tile.MapTile;
import technology.rocketjump.undermount.messaging.types.EntityMessage;
import technology.rocketjump.undermount.messaging.types.EntityPositionChangedMessage;

public class SteeringComponent {
    private final MessageDispatcher messageDispatcher;
    private LocationComponent locationComponent;
    private long ownerEntityId;
    private Vector2 destination;
    private Vector2 nextWaypoint;
    private Vector2 positionToFace;
    private TiledMap areaMap;

    public SteeringComponent(MessageDispatcher messageDispatcher) {
        this.messageDispatcher = messageDispatcher;
    }

    public void init(long ownerEntityId, TiledMap map, LocationComponent locationComponent) {
        this.locationComponent = locationComponent;
        this.ownerEntityId = ownerEntityId;
        this.areaMap = map;
    }

    public void destinationReached() {
        this.nextWaypoint = null;
        this.destination = null;
    }

    public void update(float deltaTime) {
        Vector2 steeringOutputForce = new Vector2();
        Vector2 currentPosition = this.locationComponent.getWorldPosition();
        Vector2 currentVelocity = this.locationComponent.getLinearVelocity();
        boolean updateFacing = true;
        if (this.positionToFace != null) {
            float maxAngularSpeed;
            float rotationToApply;
            float facingAngle = this.locationComponent.getFacing().angle();
            float desiredAngle = this.positionToFace.cpy().sub(this.locationComponent.getWorldPosition()).angle();
            float difference = Math.abs(facingAngle - desiredAngle);
            boolean positiveRotation = facingAngle - desiredAngle < 0.0f;
            this.rotateFacingAndApplyVelocity(deltaTime, currentVelocity, this.positionToFace);
            if (difference > 180.0f) {
                difference = 360.0f - difference;
                boolean bl = positiveRotation = !positiveRotation;
            }
            if ((rotationToApply = (maxAngularSpeed = this.locationComponent.getMaxAngularSpeed()) * deltaTime) > difference) {
                rotationToApply = difference;
            }
            if (!positiveRotation) {
                rotationToApply = -rotationToApply;
            }
            this.locationComponent.getFacing().rotate(rotationToApply);
            this.locationComponent.setFacing(this.locationComponent.getFacing());
            if (Math.abs(rotationToApply - difference) < 3.0f) {
                this.positionToFace = null;
            }
        } else if (this.nextWaypoint == null) {
            updateFacing = false;
            if (currentVelocity.len2() > 0.5f) {
                currentVelocity.mulAdd(currentVelocity.cpy().scl(-3.0f), deltaTime);
            } else {
                currentVelocity.setZero();
            }
        } else {
            DoorState doorState;
            MapTile nextTile = this.areaMap.getTile(this.nextWaypoint);
            boolean waitingForDoorToOpen = false;
            if (nextTile.hasDoorway() && !(doorState = nextTile.getDoorway().getDoorState()).equals((Object)DoorState.OPEN)) {
                this.messageDispatcher.dispatchMessage(808, new EntityMessage(nextTile.getDoorway().getDoorEntity().getId()));
                waitingForDoorToOpen = true;
            }
            Vector2 nextWaypointRelative = this.nextWaypoint.cpy().sub(currentPosition);
            if (!waitingForDoorToOpen) {
                if (this.nextWaypoint == this.destination) {
                    currentVelocity.mulAdd(currentVelocity.cpy().scl(-2.0f), deltaTime);
                    steeringOutputForce.add(nextWaypointRelative.nor().scl(2.0f));
                } else {
                    steeringOutputForce.add(nextWaypointRelative.nor().scl(3.0f));
                }
            }
            this.rotateFacingAndApplyVelocity(deltaTime, currentVelocity, nextWaypointRelative);
        }
        float maxSpeed = this.locationComponent.getMaxLinearSpeed();
        boolean isSlowed = false;
        Vector2 entityAvoidanceForce = new Vector2();
        Vector2 wallAvoidanceForce = new Vector2();
        for (MapTile cellNearCurrentPosition : this.areaMap.getNearestTiles(currentPosition)) {
            Vector2 wallToEntity;
            if (cellNearCurrentPosition.hasWall() && (wallToEntity = currentPosition.cpy().sub(cellNearCurrentPosition.getWorldPositionOfCenter())).len2() < 0.8f) {
                wallAvoidanceForce.add(wallToEntity.nor());
            }
            for (Entity otherEntity : cellNearCurrentPosition.getEntities()) {
                if (otherEntity.getId() == this.ownerEntityId || !otherEntity.getType().equals((Object)EntityType.HUMANOID)) continue;
                Vector2 separation = currentPosition.cpy().sub(otherEntity.getLocationComponent().getWorldPosition());
                float totalRadii = this.locationComponent.getRadius() + otherEntity.getLocationComponent().getRadius();
                float separationDistance = separation.len();
                if (separationDistance < totalRadii) {
                    isSlowed = true;
                }
                if (!(separationDistance < totalRadii + this.locationComponent.getRadius())) continue;
                entityAvoidanceForce.add(separation.nor());
            }
        }
        steeringOutputForce.add(wallAvoidanceForce.limit(2.0f));
        steeringOutputForce.add(entityAvoidanceForce.limit(1.0f));
        this.locationComponent.setSlowed(isSlowed);
        if (isSlowed) {
            maxSpeed *= 0.5f;
        }
        Vector2 newVelocity = currentVelocity.cpy().mulAdd(steeringOutputForce, deltaTime).limit(maxSpeed);
        Vector2 newPosition = currentPosition.cpy().mulAdd(newVelocity, deltaTime);
        this.locationComponent.setLinearVelocity(newVelocity);
        this.locationComponent.setWorldPosition(newPosition, updateFacing);
        this.repelFromWallCollisions(deltaTime);
        if (Math.floor(currentPosition.x) != Math.floor(newPosition.x) || Math.floor(currentPosition.y) != Math.floor(newPosition.y)) {
            this.messageDispatcher.dispatchMessage(null, 310, (Object)new EntityPositionChangedMessage(this.ownerEntityId, currentPosition, newPosition));
        }
    }

    private void rotateFacingAndApplyVelocity(float deltaTime, Vector2 currentVelocity, Vector2 target) {
        float angleToWaypoint = target.angle();
        float angleToVelocity = currentVelocity.angle();
        float difference = Math.abs(angleToVelocity - angleToWaypoint);
        if (difference > 3.0f) {
            boolean positiveRotation;
            boolean bl = positiveRotation = angleToVelocity - angleToWaypoint < 0.0f;
            if (difference > 30.0f) {
                currentVelocity.mulAdd(currentVelocity.cpy().scl(-3.0f), deltaTime);
            }
            if (difference > 180.0f) {
                difference = 360.0f - difference;
                boolean bl2 = positiveRotation = !positiveRotation;
            }
            if (!positiveRotation) {
                difference = -difference;
            }
            currentVelocity.rotate(difference * 2.0f * deltaTime);
        } else {
            this.positionToFace = null;
        }
    }

    public void setDestination(Vector2 destination) {
        this.destination = destination;
    }

    public void setNextWaypoint(Vector2 nextWaypoint) {
        this.nextWaypoint = nextWaypoint;
    }

    public void setPositionToFace(Vector2 positionToFace) {
        this.positionToFace = positionToFace;
    }

    private void repelFromWallCollisions(float deltaTime) {
        Vector2 currentPosition = this.locationComponent.getWorldPosition();
        Vector2 adjustmentForce = new Vector2();
        for (MapTile cellNearNewPosition : this.areaMap.getNearestTiles(currentPosition)) {
            if (!cellNearNewPosition.hasWall()) continue;
            Vector2 wallToPosition = currentPosition.cpy().sub(cellNearNewPosition.getWorldPositionOfCenter());
            if (!(Math.abs(wallToPosition.x) < 0.5f + this.locationComponent.getRadius()) || !(Math.abs(wallToPosition.y) < 0.5f + this.locationComponent.getRadius())) continue;
            adjustmentForce.add(wallToPosition.nor());
        }
        currentPosition.mulAdd(adjustmentForce, deltaTime);
        this.locationComponent.setWorldPosition(currentPosition, false);
    }
}

